<?php
/**
 * Migration Page
 *
 * @since    1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
?>	
<div class="tipi-block tipi-migration">
	<h3><?php esc_html_e( 'Migration', 'lets-review' ); ?></h3>
	<p><?php esc_html_e( 'If you have reviews in another review system and wish to migrate them over to Let\'s Review\'s system, then simply select the Old review system below and hit the "Convert Old Reviews" button.', 'lets-review' ); ?></a>.</p>
	<br>
	<form action="options.php" method="post">
		<?php settings_fields( 'lets-review-settings-migration' ); ?>
		<?php do_settings_sections( 'lets-review-migration' ); ?>
		<?php submit_button( esc_html__( 'Convert Old Reviews', 'lets-review' ) ); ?>
		<?php wp_nonce_field( 'lets-review-migration', 'lets-review-migration-nonce' ); ?>
	</form>
</div>